/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.porthistory;

import emulator.hardware.bits.SharedBit;
import emulator.hardware.io.Port6522;
import emulator.hardware.io.Port6522Listener;
import emulator.hardware.io.Via6522;
import emulator.history.BitStateChange;
import emulator.history.BitStateHistory;
import emulator.util.events.Event;
import emulator.util.events.EventAggregator;
import java.util.Observable;
import java.util.Observer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortStateCollector {
    static Logger logger = LogManager.getLogger((String)PortStateCollector.class.getName());
    private EventAggregator eventAggregator;
    private BitStateHistory history;
    private Via6522 via;
    private SharedBit io;
    private long currentTick;
    private static boolean useEventAggregator = false;

    public PortStateCollector(EventAggregator eventAggregator, BitStateHistory history, Via6522 via, Port6522 port, SharedBit io) {
        this.eventAggregator = eventAggregator;
        this.history = history;
        this.via = via;
        this.io = io;
        this.currentTick = 0L;
        port.addPortListener(new PortListener());
        Observer ioObserver = useEventAggregator ? new IoObserverWithAggregator() : new IoObserver();
        ioObserver.update(null, null);
        io.addObserver(ioObserver);
    }

    public class IoObserver
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            PortStateCollector.this.history.add(new BitStateChange(PortStateCollector.this.currentTick, PortStateCollector.this.io.getValue()));
        }
    }

    public class IoObserverWithAggregator
    implements Observer {
        @Override
        public void update(Observable o, Object arg) {
            try {
                PortStateCollector.this.eventAggregator.fire(new IoStateEvent(PortStateCollector.this.currentTick, PortStateCollector.this.io.getValue()));
            }
            catch (InterruptedException ex) {
                logger.error("Event aggregator was interrupted", (Throwable)ex);
            }
        }
    }

    public class IoStateEvent
    implements Event {
        private long tick;
        private boolean value;

        public IoStateEvent(long tick, boolean value) {
            this.tick = tick;
            this.value = value;
        }

        @Override
        public void execute() {
            PortStateCollector.this.history.add(new BitStateChange(this.tick, this.value));
        }
    }

    public class PortListener
    implements Port6522Listener {
        @Override
        public void handlePre(Port6522 port) {
            PortStateCollector.this.currentTick = PortStateCollector.this.via.getTicks();
        }

        @Override
        public void handlePost(Port6522 port) {
        }
    }
}

